/****************************************************************************
                   Microsoft RPC Version 2.0
           Copyright Microsoft Corp. 1992, 1993, 1994- 1996
                      InOut Example

    FILE:       inoutc.c

    USAGE:      inoutc   -n network_address
                         -p protocol_sequence
                         -e endpoint
                         -o options
                         -1 short_value_1
                         -2 short_value_2
                         -3 float_value_3

    PURPOSE:    Client side of RPC distributed application inout

    FUNCTIONS:  main() - binds to server and calls remote procedure

    COMMENTS:   This distributed application demonstrates in, out
                parameters.

****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include "inout.h"    // header file generated by MIDL compiler

#define PURPOSE \
"This Microsoft RPC Version 2.0 sample program demonstrates\n\
use of the [in], [out], and [in, out] attributes. For more\n\
information about attributes and RPC API functions, see the\n\
Microsoft RPC programming guide and reference.\n\n"

#define DESCRIPTION \
"One [in], one [out], and one [in,out] parameter are defined\n\
for the function InOutProc(). This program displays the values\n\
of these parameters before and after the remote procedure call.\n\n"

void Usage(char * pszProgramName)
{
    fprintf(stderr, "%s", PURPOSE);
    fprintf(stderr, "Usage:  %s\n", pszProgramName);
    fprintf(stderr, " -p protocol_sequence\n");
    fprintf(stderr, " -n network_address\n");
    fprintf(stderr, " -e endpoint\n");
    fprintf(stderr, " -o options\n");
    fprintf(stderr, " -1 parameter_1\n");
    fprintf(stderr, " -2 parameter_2\n");
    fprintf(stderr, " -3 parameter_3\n");
    exit(1);
}

void _CRTAPI1 main(int argc, char **argv)
{
    RPC_STATUS status;
    unsigned char * pszUuid             = NULL;
    unsigned char * pszProtocolSequence = "ncacn_np";
    unsigned char * pszNetworkAddress   = NULL;
    unsigned char * pszEndpoint         = "\\pipe\\inout";
    unsigned char * pszOptions          = NULL;
    unsigned char * pszStringBinding    = NULL;
    short   s1 = 257;
    short   s2 = 631;
    float   f3 = (float) 0.406;
    int i;

    /* allow the user to override settings with command line switches */
    for (i = 1; i < argc; i++) {
        if ((*argv[i] == '-') || (*argv[i] == '/')) {
            switch (tolower(*(argv[i]+1))) {
            case 'p':  // protocol sequence
                pszProtocolSequence = argv[++i];
                break;
            case 'n':  // network address
                pszNetworkAddress = argv[++i];
                break;
            case 'e':
                pszEndpoint = argv[++i];
                break;
            case 'o':
                pszOptions = argv[++i];
                break;
            case '1':
                s1 = (short) atoi(argv[++i]);
                break;
            case '2':
                s2 = (short) atoi(argv[++i]);
                break;
            case '3':
                f3 = (float) atof(argv[++i]);
                break;
            case 'h':
            case '?':
            default:
                Usage(argv[0]);
            }
        }
        else
            Usage(argv[0]);
    }

    printf("%s", DESCRIPTION);

    /* Use a convenience function to concatenate the elements of  */
    /* the string binding into the proper sequence.               */
    status = RpcStringBindingCompose(pszUuid,
                                     pszProtocolSequence,
                                     pszNetworkAddress,
                                     pszEndpoint,
                                     pszOptions,
                                     &pszStringBinding);
    printf("RpcStringBindingCompose returned 0x%x\n", status);
    printf("pszStringBinding = %s\n", pszStringBinding);
    if (status) {
        exit(status);
    }

    /* Set the binding handle that will be used to bind to the server. */
    status = RpcBindingFromStringBinding(pszStringBinding,
                                         &inout_IfHandle);
    printf("RpcBindingFromStringBinding returned 0x%x\n", status);
    if (status) {
        exit(status);
    }

    printf("Calling the remote procedure 'InOutProc'\n");
    printf("  parameters = %d %d %0.3f\n", s1, s2, f3);

    RpcTryExcept {
        InOutProc(s1, &s2, &f3);  // call the remote procedure

        printf("Returning from the remote procedure 'InOutProc'\n");
        printf("  parameters = %d %d %0.3f\n", s1, s2, f3);

        Shutdown();
    }
    RpcExcept(1) {
        printf("Runtime reported exception %ld\n", RpcExceptionCode() );
    }
    RpcEndExcept

    /* The call to the remote procedure is complete. */
    /* Free the string and binding handle.           */
    status = RpcBindingFree(&inout_IfHandle);
    printf("RpcBindingFree returned 0x%x\n", status);
    if (status) {
        exit(status);
    }

    status = RpcStringFree(&pszStringBinding);
    printf("RpcStringFree returned 0x%x\n", status);
    if (status) {
        exit(status);
    }

    exit(0);

}  // end main()


/*********************************************************************/
/*                 MIDL allocate and free                            */
/*********************************************************************/

void __RPC_FAR * __RPC_USER midl_user_allocate(size_t len)
{
    return(malloc(len));
}

void __RPC_USER midl_user_free(void __RPC_FAR * ptr)
{
    free(ptr);
}

/* end file inoutc.c */
